/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	tkm_config.h
*  :	Flynn Yin WangPan
*  :	V2.31 lite
*  :	2019/1
*  :	ͷļ
*  ע:    HR7P203ԺӦ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#ifndef   __TKM_CONFIG_H__
#define   __TKM_CONFIG_H__

#include <hic.h>
#include "common.h"
#include "main.h"

/*  */
/**********************************************************************************************************************************/
#define  TK_NUM						6			//ذ1--24

#define  TK_Channel0				TK4			//TK0--TK11  ظ ͬ
#define  TK_Channel1				TK5
#define  TK_Channel2				TK6
#define  TK_Channel3				TK3
#define  TK_Channel4				TK2
#define  TK_Channel5				TK1
#define  TK_Channel6				TK7

#define  TK_Channel7				TK0
#define  TK_Channel8				TK8
#define  TK_Channel9				TK9
#define  TK_Channel10				TK10
#define  TK_Channel11				TK11


#define  TK_Threshold_Channel0		80			//Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel1		80			//
#define  TK_Threshold_Channel2		80			//
#define  TK_Threshold_Channel3		80			//
#define  TK_Threshold_Channel4		80			//
#define  TK_Threshold_Channel5		80			//
#define  TK_Threshold_Channel6		100			//
#define  TK_Threshold_Channel7		100			//
#define  TK_Threshold_Channel8		100			//
#define  TK_Threshold_Channel9		100			//
#define  TK_Threshold_Channel10		100			//
#define  TK_Threshold_Channel11		100			//


#define  TK_Singlepress				OFF         //ON/OFF ͬһ̽һǿ ʵʰѹ3  OFF аͬʱ
#define  TK_Mult_inhibition         2           // 0---5  ټϵ 0   1 50% 225%  312.5% 46.25%   ڽָѹټ
#define  TK_Amplifi_setting			0x000FFFFF  //TK Ŵϵ趨  1--0x0FFFFFFF
#define  TK_Samples_perscan			3			// ۼ趨1--16 16λ
#define  TK_Threshold_release		9			// 0.4-0.9 ɿ趨0.530ɿҪ15  5==50%
#define  TK_BaseSamples_perscan		70			// ߸ 趨1--65535
#define  TK_Press_timeout			(120*125)	// 120s ʱǿȡ˰״̬ƽ 125--65535 
#define  TK_Debounce_press			15			// µĴ趨
#define  TK_Debounce_release		5			// 뿪Ĵ趨
												// ûаʱԶӦ

#define  Timercounter_10ms          80          // ʱ10MS 80 
#define  Max_Minvalueoff_filter     ON          // ON/ OFF ȥСֵ
#define  Jitter_Function			OFF
#define  Jitter_level1_Threshold    800         // When more than this  value use a specilize filter  base was locked                 Type value  100*TK_NUM 
#define  Jitter_level2_Threshold    8000        // When more than this  value use a specilize filter2 Debounce  conter was cleared    Type value  500*TK_NUM 
#define  Jitter_tolerance           0			//0 --5  ݴ趨
#define  Auto_Jitter_hradware       OFF			//ӲƵ
#define  Auto_Jitter_software       OFF         //Ƶ
#define  TK_Guardsensor_output      OFF			//ܿ SNR


#define  TK_Lowpowermode				ON
#define  TK_Wdttimer_sleepsetting		256         //mS  16/32/64/128/256/512/1024/2046
#define  TK_Mode0_nokeytoswitch_time	10*100		// 10S  0--65535  Mode0 no key press time to switch Mode2  
#define  TK_Sleep_Threshold             90
#define  TK_UARToutput_function		ON			// ON/ OFF
#define  TK_UARToutput_Baudrate		115200		// 115200  57600 38400 19200 .......9600
#define  TK_UARToutput_Databit      8			// 4,5,6,7,8
#define  TK_UARToutput_Stopbit      1			// 1,2,3(1.5)
#define  TK_UARToutput_Verifybit    No			//No Even Odd 


#define  TK_IOoutput_function    ON           // ON/ OFF
#define  TK_IOoutput_NUM         6            // 1--16

#define  TK_IOoutput_port0   PE4               // PA PB PC  Any bit
#define  TK_IOoutput_port1   PE3
#define  TK_IOoutput_port2   PE2
#define  TK_IOoutput_port3   PE5
#define  TK_IOoutput_port4   PE0
#define  TK_IOoutput_port5   PE1

#define  TK_IOoutput_port6   PB4
#define  TK_IOoutput_port7   PB3
#define  TK_IOoutput_port8   PB2

#define  TK_IOoutput_port9   PC6
#define  TK_IOoutput_port10  PC7
#define  TK_IOoutput_port11  PC7
#define  TK_IOoutput_port12  PC7
#define  TK_IOoutput_port13  PC7
#define  TK_IOoutput_port14  PC7
#define  TK_IOoutput_port15  PC7

#define  TK_IOoutput_trise0   PET4               // PA PB PC  TRISE bit
#define  TK_IOoutput_trise1   PET3
#define  TK_IOoutput_trise2   PET2
#define  TK_IOoutput_trise3   PET5
#define  TK_IOoutput_trise4   PET0
#define  TK_IOoutput_trise5   PET1


#define  TK_IOoutput_trise6   PBT4
#define  TK_IOoutput_trise7   PBT3
#define  TK_IOoutput_trise8   PBT2

#define  TK_IOoutput_trise9    PCT6
#define  TK_IOoutput_trise10   PCT7
#define  TK_IOoutput_trise11   PCT7
#define  TK_IOoutput_trise12   PCT7
#define  TK_IOoutput_trise13   PCT7
#define  TK_IOoutput_trise14   PCT7
#define  TK_IOoutput_trise15   PCT7


#define  TK_IOLED_Function  Indicate          // Indicate/Toggle ɿ ǿشģʽ
#define  LED_On    0     //  0/1 
#define  LED_Off   1     //  0/1 



//TK_advance
 
#define  TK_reg_TKTUN				0x58        //For TKTUN register  Ƚ˲ʱ2*Tosc  Cxŵʱ512*Tosc
#define  TK_reg_TKCTL1				0x21        //
#define  TK_reg_TKFCTL				0x90        //
#define  TK_reg_VRC1				0x02        //For VRC1  register  VREF1=1.5V Ƚͽֹ 

#define  TK0						0			// PA0
#define  TK1						1			// PA1
#define  TK2						2			// PA2
#define  TK3						3			// PA3
#define  TK4						4			// PA4
#define  TK5						5			// PA5
#define  TK6						6			// PA6
#define  TK7						7			// PA7	
#define  TK8						(0x80+8)	// PB6
#define  TK9						(0x80+9)	// PB7
#define  TK10						(0x20+10)   // PE0
#define  TK11						(0x20+11)   // PE1

	
#define	 SLAVE_ADDR					0x4E		//ӻַ
#define  COMMOND4					0x50		//4ֵ
#define  COMMOND0					0x51		//0ͨ
#define  COMMOND1					0x5A		//1
#define  COMMOND2					0x5B		//2˲
#define  COMMOND3					0x5C		//3

extern const uchar Channel_table[];
extern const uint  Threshold_table[];
extern const uchar Channel_md2table[];
extern const uint  Threshold_md2table[];

extern const uchar REG_PAT[];
extern const uchar ChannelSum;
extern const uchar DF_TK_Singlepress;

extern ulong pow_ulong(uchar);

extern void TKInit(void);	    //TKʼ
extern void  TKScan(void);		//TKɨ
extern void  TKRead(void);		//TKȡֵ
//extern void Config_TKIO(uchar TK_Channelx );
extern void Config_TKIO2(uchar TK_Channelx );
extern void Tk_service(void);
extern void Timer_check(void);
extern void Update_TKdata(void);
extern void Tk_getbaselinedata(void);
extern void Singlekeyprocess(void);
extern void Force_average(uchar num_th);
extern uint DataFilter(uint Origin,uint Befilter);
extern uchar Mult_inhibition(uint Dlt_data ,uchar Inhibition_data);
extern void TK_Modeswitch(void);
//#if TK_Lowpowermode  ==ON   
extern void Sleep_thenscan(void);
extern void TKStandby(void);
extern void SleepMode(void);
extern	void WDT_Clear(void);
//#endif
void TK_IO_output(void);
//extern volatile section3 uchar PCStack[32] @0x01E0;
//extern void Update_filterdata(uchar j,uint TK_Samplevalue_stp );
//extern void Update_averagedata(uchar j,uint TK_Samplevalue_stp );
/************************************************************************************************************************************/
#endif


